﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;

public partial class Admin_NeiRong_GeShou_ZengJia : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("增加歌手", "网站后台", "增加歌手", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            增加歌手();
    }

    private void 增加歌手()
    {
        访问.验证权限("19");
        String 歌手名称 = GeShou_YueDuiMingChen.Text;
        String 歌手图片;
        if (Request.Files.Count != 1)
            throw new Exception("必须上传歌手图片");
        int ZGID=常用.SQL_最高ID(访问.连接,程序.数据表前缀+"内容_音乐_歌手");
        String 存储文件夹 = 程序.安装位置 + "Data/DT_GeShou/" + (ZGID /500) + "/";
        if (!Directory.Exists(Server.MapPath(存储文件夹)))
            Directory.CreateDirectory(Server.MapPath(存储文件夹));
        String 文件名 = "G" + ZGID + 常用.随机字符(30);
        if (Request.Files[0].ContentLength < 1)
            throw new Exception("歌手图片不能为空");
        String 后缀 = Path.GetExtension(Request.Files[0].FileName).Substring(1);
        if (!常用.是否允许后缀("gif,jpg,jpe,jpeg,png,tif,tiff,bmp", 后缀))
            throw new Exception("图片格式不正确");
        Request.Files[0].SaveAs(Server.MapPath(存储文件夹 + 文件名 + "." + 后缀));
        歌手图片 = 存储文件夹 + 文件名 + "." + 后缀;
        String 歌手类型;
        if (GeShouLeiXing_0.Checked)
            歌手类型 = "男歌手";
        else if (GeShouLeiXing_1.Checked)
            歌手类型 = "女歌手";
        else
            歌手类型 = "乐队组合";
        String 歌手简介 = GeShouJianJie.Text;
        String 歌手地区;
        if (GeShouDiQu_0.Checked)
            歌手地区 = "大陆";
        else if (GeShouDiQu_1.Checked)
            歌手地区 = "港台";
        else if (GeShouDiQi_2.Checked)
            歌手地区 = "欧美";
        else if (GeShouDiQu_3.Checked)
            歌手地区 = "日韩";
        else
            歌手地区 = "其它";

        if (歌手名称.Length < 1 || 歌手名称.Length > 20)
            throw new Exception("歌手名称的长度只能是1-20之间。");
        if (歌手简介.Length < 1 || 歌手简介.Length > 4000)
            throw new Exception("歌手简介的长度只能是1-4000之间。");

        SqlCommand 语句 = new SqlCommand("INSERT INTO [" + 程序.数据表前缀 + "内容_音乐_歌手]([ID],[歌手/乐队名称],[歌手图片],[歌手类型],[歌手地区],[歌手简介])" +
            "VALUES(@ID,@歌手_乐队名称,@歌手图片,@歌手类型,@歌手地区,@歌手简介)", 访问.连接);
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ZGID;
        语句.Parameters.Add("@歌手_乐队名称", SqlDbType.NVarChar).Value = 歌手名称;
        语句.Parameters.Add("@歌手图片", SqlDbType.NVarChar).Value = 存储文件夹 + 文件名 + "." + 后缀;
        语句.Parameters.Add("@歌手类型", SqlDbType.NVarChar).Value = 歌手类型;
        语句.Parameters.Add("@歌手地区", SqlDbType.NVarChar).Value = 歌手地区;
        语句.Parameters.Add("@歌手简介", SqlDbType.NVarChar).Value = 歌手简介;
        语句.ExecuteNonQuery();
        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("增加歌手[" + 歌手名称 + "]。", 访问.用户["昵称"].ToString());

        Response.Redirect("GeShouGuanLi.aspx");
    }
}
